﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;
using LFS_External.InSim;
using System.Reflection;
using System.Text.RegularExpressions;

namespace LFS_External_Client
{
    class misc
    {

        static readonly string LogPath = Path.Combine(Application.StartupPath, "handledErrorLog.txt");
        static public void manageHandledException(Exception e)
        {
            try
            {
                string mainErrorFile = "File created on: " + DateTime.Now.ToFileTime();
                try
                {
                    StreamReader ErRe1 = new StreamReader(LogPath);
                    mainErrorFile = ErRe1.ReadToEnd();
                    ErRe1.Dispose();
                    ErRe1.Close();
                }
                catch { }

                using (StreamWriter writer = new StreamWriter(LogPath))
                {
                    writer.WriteLine(mainErrorFile);
                    writer.WriteLine();
                    writer.WriteLine("< < < < - - - - - - - - - - - - - - - - - - - > > > >");
                    writer.WriteLine();
                    writer.WriteLine("Name: " + Assembly.GetExecutingAssembly().GetName().Name);
                    writer.WriteLine("Version: " + Assembly.GetExecutingAssembly().GetName().Version.ToString());
                    writer.WriteLine("Date: " + DateTime.Now.ToString());
                    writer.WriteLine("OS: " + Environment.OSVersion.VersionString);
                    writer.WriteLine("Culture: " + Thread.CurrentThread.CurrentUICulture);
                    writer.WriteLine("Message: " + e.Message);
                    writer.WriteLine("Source: " + e.Source);
                    writer.WriteLine("Target: " + e.TargetSite);
                    writer.WriteLine("Stack Trace: " + e.StackTrace);
                    writer.WriteLine("Inner Exception: " + e.InnerException);
                }

                try
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Handled exception data written in log file!");
                }
                catch { }
            }
            catch
            {
                Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error!");
            }
        }

        static public void buildErrorReportOnCrash(Exception E, string reportSituation, string errorDescr, string[] additionalInfo, string Username)
        {
            string errorInfo = @"errors";
            string userInfo = @"users";
            bool MEFCF = false;
            bool SEFCF = false;
            bool MEFWF = false;
            bool SEFWF = false;
            try
            {
                if (File.Exists(userInfo + "\\" + Username + ".txt") == true)
                {
                    File.Copy(Application.ExecutablePath.Remove(Application.ExecutablePath.LastIndexOf('\\')) + "\\users\\" + Username + ".txt", Application.ExecutablePath.Remove(Application.ExecutablePath.LastIndexOf('\\')) + "\\users\\" + "BACKUP (" + Username + ")" + Convert.ToString(System.DateTime.Now.Hour) + ":" + Convert.ToString(System.DateTime.Now.Minute) + ":" + Convert.ToString(System.DateTime.Now.Second) + " " + Convert.ToString(System.DateTime.Now.Day) + "." + Convert.ToString(System.DateTime.Now.Month) + "." + Convert.ToString(System.DateTime.Now.Year));
                }
            }
            catch
            {
                reportSituation += "-UBF";
            }
            /*string errorCode = Convert.ToString(System.DateTime.Now.Hour).PadLeft(2, '0');
            errorCode += Convert.ToString(System.DateTime.Now.Minute).PadLeft(2, '0');
            errorCode += Convert.ToString(System.DateTime.Now.Second).PadLeft(2, '0');
            errorCode += Convert.ToString(System.DateTime.Now.Day).PadLeft(2, '0');
            errorCode += Convert.ToString(System.DateTime.Now.Month).PadLeft(2, '0');
            errorCode += Convert.ToString(System.DateTime.Now.Year) + "-" + errorDescr;*/

            string errorCode = DateTime.Now.ToBinary() + "-" + errorDescr;

            try
            {
                if (File.Exists(errorInfo + "\\errorFile.txt") == false)
                {
                    File.Create(errorInfo + "\\errorFile.txt");
                    StreamWriter NewFile = new StreamWriter(errorInfo + "\\errorFile.txt");
                    NewFile.WriteLine("File created on: " + System.DateTime.Now.ToString());
                    NewFile.WriteLine("");
                    NewFile.Flush();
                    NewFile.Close();
                }
            }
            catch
            {
                MEFCF = true;
            }
            try
            {
                /*if (File.Exists(errorInfo + "\\" + errorCode + ".txt") == false)
                {
                    File.Create(errorInfo + "\\" + errorCode + ".txt");
                    StreamWriter NewFile = new StreamWriter(errorInfo + "\\" + errorCode + ".txt");
                    NewFile.WriteLine("File created on: " + System.DateTime.Now.ToString());
                    NewFile.WriteLine("");
                    NewFile.Flush();
                    NewFile.Close();
                }*/
            }
            catch
            {
                SEFCF = true;
            }

            try
            {
                string mainErrorFile = "Failed to read file!";
                try
                {
                    StreamReader ErRe1 = new StreamReader(errorInfo + "\\errorFile.txt");
                    mainErrorFile = ErRe1.ReadToEnd();
                    ErRe1.Dispose();
                    ErRe1.Close();
                }
                catch { }

                //Thread.Sleep(250);
                StreamWriter ErWr1 = new StreamWriter(errorInfo + "\\errorFile.txt");
                try
                {
                    ErWr1.WriteLine(mainErrorFile);
                }
                catch { }
                ErWr1.WriteLine("------------------------------------------------------------" + errorCode + "------------------------------------------------------------");
                ErWr1.WriteLine("Exception: " + E.ToString());
                ErWr1.WriteLine("------------------------------------------------------------");
                try
                {
                    ErWr1.WriteLine("Inner: " + E.InnerException.ToString());
                }
                catch
                {
                    ErWr1.WriteLine("Inner: Inner exception not available");
                }
                try
                {
                    ErWr1.WriteLine("Inner: " + E.InnerException.InnerException.ToString());
                }
                catch
                {
                    ErWr1.WriteLine("Inner: Inner exception(x2) not available");
                }
                try
                {
                    ErWr1.WriteLine("Inner: " + E.InnerException.InnerException.InnerException.ToString());
                }
                catch
                {
                    ErWr1.WriteLine("Inner: Inner exception(x3) not available");
                }
                ErWr1.WriteLine("------------------------------------------------------------");
                ErWr1.WriteLine("");
                ErWr1.WriteLine("Report: " + reportSituation);
                ErWr1.WriteLine("");
                ErWr1.WriteLine("------------------------------------------------------------");
                for (int tempint1 = 0; tempint1 < 15; tempint1++)
                {
                    try
                    {
                        ErWr1.WriteLine("Add. Info(" + tempint1 + "): " + additionalInfo[tempint1]);
                    }
                    catch
                    {
                        ErWr1.WriteLine("Add. Info(" + tempint1 + "): Additional info n." + tempint1 + " does not contain any information.");
                    }
                }
                ErWr1.WriteLine("------------------------------------------------------------");
                ErWr1.WriteLine("");
                ErWr1.WriteLine("User: " + Username);
                ErWr1.WriteLine("");
                ErWr1.WriteLine("------------------------------------------------------------");
                ErWr1.WriteLine("");
                ErWr1.WriteLine("");
                ErWr1.Flush();
                ErWr1.Close();
            }
            catch
            {
                MEFWF = true;
            }

            try
            {
                /*string subErrorFile = "Failed to read file!";
                try
                {
                    StreamReader ErRe2 = new StreamReader(errorInfo + "\\" + errorCode + ".txt");
                    subErrorFile = ErRe2.ReadToEnd();
                    ErRe2.Dispose();
                    ErRe2.Close();
                }
                catch { }

                ///Thread.Sleep(250);
                StreamWriter ErWr2 = new StreamWriter(errorInfo + "\\" + errorCode + ".txt");
                try
                {
                    ErWr2.WriteLine(subErrorFile);
                }
                catch { }
                ErWr2.WriteLine("------------------------------------------------------------" + errorCode + "------------------------------------------------------------");
                ErWr2.WriteLine("Exception: " + E.ToString());
                ErWr2.WriteLine("------------------------------------------------------------");
                try
                {
                    ErWr2.WriteLine("Inner: " + E.InnerException.ToString());
                }
                catch
                {
                    ErWr2.WriteLine("Inner: Inner exception not available");
                }
                try
                {
                    ErWr2.WriteLine("Inner: " + E.InnerException.InnerException.ToString());
                }
                catch
                {
                    ErWr2.WriteLine("Inner: Inner exception(x2) not available");
                }
                try
                {
                    ErWr2.WriteLine("Inner: " + E.InnerException.InnerException.InnerException.ToString());
                }
                catch
                {
                    ErWr2.WriteLine("Inner: Inner exception(x3) not available");
                }
                ErWr2.WriteLine("");
                ErWr2.WriteLine("------------------------------------------------------------");
                ErWr2.WriteLine("");
                ErWr2.WriteLine("Report: " + reportSituation);
                ErWr2.WriteLine("");
                ErWr2.WriteLine("------------------------------------------------------------");
                ErWr2.WriteLine("");
                ErWr2.WriteLine("User: " + Username);
                ErWr2.WriteLine("");
                ErWr2.WriteLine("------------------------------------------------------------");
                ErWr2.WriteLine("");
                ErWr2.WriteLine("");
                //ErWr.Flush();
                ErWr2.Close();*/
            }
            catch
            {
                SEFWF = true;
            }

            if (MEFCF == true && SEFCF == true)
            {
                reportSituation += "-EFCF";
            }
            else if (MEFCF == true && SEFCF == false)
            {
                reportSituation += "-MEFCF";
            }
            else if (MEFCF == false && SEFCF == true)
            {
                reportSituation += "-SEFCF";
            }

            if (MEFWF == true && SEFWF == true)
            {
                reportSituation += "-EFWF";
            }
            else if (MEFWF == true && SEFWF == false)
            {
                reportSituation += "-MEFWF";
            }
            else if (MEFWF == false && SEFWF == true)
            {
                reportSituation += "-SEFWF";
            }

            Form1.InSim.Send_MST_Message("/msg ^3» ^1An error has occured. Please report to forums.");
            Form1.InSim.Send_MST_Message("/msg ^3» ^1Report: ^8" + reportSituation);
            Form1.InSim.Send_MST_Message("/msg ^3» ^1E. code: ^8" + errorCode);
            Form1.InSim.Send_MST_Message("/msg ^3» ^1Occured with user: ^3" + Username);
        }

        static public bool proccessFindAndKill(string name)
        {
            //here we're going to get a list of all running processes on
            //the computer
            foreach (Process clsProcess in Process.GetProcesses())
            {
                //now we're going to see if any of the running processes
                //match the currently running processes by using the StartsWith Method,
                //this prevents us from incluing the .EXE for the process we're looking for.
                //. Be sure to not
                //add the .exe to the name you provide, i.e: NOTEPAD,
                //not NOTEPAD.EXE or false is always returned even if
                //notepad is running
                if (clsProcess.ProcessName.StartsWith(name))
                {
                    //since we found the proccess we now need to use the
                    //Kill Method to kill the process. Remember, if you have
                    //the process running more than once, say IE open 4
                    //times the loop thr way it is now will close all 4,
                    //if you want it to just close the first one it finds
                    //then add a return; after the Kill
                    try
                    {
                        clsProcess.Kill();
                    }
                    catch { }
                    //process killed, return true
                    return true;
                }
            }
            //process not found, return false
            return false;
        }

        static public bool saveAllUsers()
        {
            for (int i = 0; i < Form1.Connections.Count; i++)
            {
                try
                {
                    dbProcess.userUpdateStats(Form1.Connections[i]);
                }
                catch
                {
                    saveAllUsers(i + 1);
                    Form1.InSim.Send_MST_Message("^3» ^7User save ^1failed^7: " + Form1.Connections[i].Username);
                    return false;
                }
            }
            return true;
        }
        static public bool saveAllUsers(int startFrom)
        {
            if (startFrom < Form1.Connections.Count)
            {
                for (int i = startFrom; i < Form1.Connections.Count; i++)
                {
                    try
                    {
                        dbProcess.userUpdateStats(Form1.Connections[i]);
                    }
                    catch
                    {
                        saveAllUsers(i + 1);
                        Form1.InSim.Send_MST_Message("^3» ^7User save ^1failed^7: " + Form1.Connections[i].Username);
                        return false;
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        static public clsConnection convertToConnection(clsPlayer P)
        {
            foreach (clsConnection C in Form1.Connections)
            {
                if (C.PlayerID == P.PlayerID)
                {
                    return C;
                }
            }
            return new clsConnection();
        }

        static public clsPlayer convertToPlayer(clsConnection C)
        {
            foreach (clsPlayer P in Form1.Players)
            {
                if (P.PlayerID == C.PlayerID)
                {
                    return P;
                }
            }
            return new clsPlayer();
        }

        static public byte convertToUCID(byte PLID)
        {
            return Form1.Players[Form1.GetPlyIdx(PLID)].UniqueID;
        }

        static public byte convertToPLID(byte UCID)
        {
            return Form1.Connections[Form1.GetConnIdx(UCID)].PlayerID;
        }

        static public int getRandNum()
        {
            Random tempRand1 = new Random();
            return tempRand1.Next();
        }

        static public int getRandNum(int max)
        {
            Random tempRand1 = new Random();
            return tempRand1.Next(max) + 1;
        }

        static public int getRandNum(int min, int max)
        {
            Random tempRand1 = new Random();
            return (tempRand1.Next(min, max));
        }

        static public void clipboardsettext (string text)
        {
            Clipboard.SetText(text, TextDataFormat.UnicodeText);
        }

        #region Matrix System

        public static string matrixAdd(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0').ToString().PadLeft(strIndex, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, "1".PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + "1".PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0').ToString().PadLeft(strIndex, '0') + tempString2;
            }
        }
        public static string matrixAdd(int index, string wholeString, string Stage)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, Stage.PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + Stage.PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
        }
        public static string matrixAdd(int index, string wholeString, int Stage)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, Stage.ToString().PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + Stage.ToString().PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
        }

        public static string matrixDel(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, "0".PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
        }

        public static string matrixRangeFix(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                if (wholeString.Remove(0, range * strIndex - strIndex).Contains("1") == false)
                {
                    int idxDifference = range * strIndex - wholeString.Length;
                    string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }
        public static string matrixRangeFixToOne(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                if (wholeString.Remove(0, range * strIndex - strIndex).Contains("1") == false)
                {
                    string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
                else
                {
                    string tempString1 = wholeString.Remove(wholeString.LastIndexOf('1'));
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }
        public static string matrixRangeFixOverride(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }

        public static bool matrixIsNotZero(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return false;
            }

            Regex r = new Regex("[0-9]".PadLeft(strIndex, '|').Replace("|", "[0-9]"));
            string s = wholeString.Substring(index * strIndex - strIndex, strIndex);
            if (s != "0".PadLeft(strIndex, '0'))
            {
                return r.IsMatch(s);
            }
            else
            {
                return false;
            }
        }
        public static bool matrixIsOne(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return false;
            }

            return wholeString.Substring(index * strIndex - strIndex, strIndex).Contains("1".PadLeft(strIndex, '0'));
        }
        public static string matrixIndex(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return "0".PadLeft(strIndex, '0');
            }

            return wholeString.Substring((index * strIndex) - strIndex, strIndex);
        }
        public static int matrixIndexSum(string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            return wholeString.Length / strIndex;
        }
        public static int matrixIndexSum(string wholeString, bool zeroTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            int indexSum = 0;
            wholeString = wholeString.Replace("9", "1");
            wholeString = wholeString.Replace("8", "1");
            wholeString = wholeString.Replace("7", "1");
            wholeString = wholeString.Replace("6", "1");
            wholeString = wholeString.Replace("5", "1");
            wholeString = wholeString.Replace("4", "1");
            wholeString = wholeString.Replace("3", "1");
            wholeString = wholeString.Replace("2", "1");

            for (int i = 0; i < wholeString.Length / strIndex; i++)
            {
                if (zeroTracking == false)
                {
                    if (wholeString.Contains("1") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == true)
                        {
                            indexSum += 1;
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
                else
                {
                    if (wholeString.Contains("0") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == false)
                        {
                            indexSum += 1;
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
            }
            return indexSum;
        }

        public static int matrixIndexSerialNumber(int index, string wholeString, bool zeroTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            int indexSum = 0;
            wholeString = wholeString.Replace("9", "1");
            wholeString = wholeString.Replace("8", "1");
            wholeString = wholeString.Replace("7", "1");
            wholeString = wholeString.Replace("6", "1");
            wholeString = wholeString.Replace("5", "1");
            wholeString = wholeString.Replace("4", "1");
            wholeString = wholeString.Replace("3", "1");
            wholeString = wholeString.Replace("2", "1");

            for (int i = 0; i < wholeString.Length / strIndex; i++)
            {
                if (zeroTracking == false)
                {
                    if (wholeString.Contains("1") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == true)
                        {
                            indexSum += 1;
                            if (indexSum == index)
                            {
                                return i;
                            }
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
                else
                {
                    if (wholeString.Contains("0") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == false)
                        {
                            indexSum += 1;
                            if (indexSum == index)
                            {
                                return i;
                            }
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
            }
            return indexSum;
        }

        static public int matrixIndexSerialNumberX(int index, string wholeString, bool zeroTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return 0;
            }

            int serialNumb = 0;
            int lastNumb = 0;
            int whileCounter = 0;
            wholeString = wholeString.Replace("9", "1");
            wholeString = wholeString.Replace("8", "1");
            wholeString = wholeString.Replace("7", "1");
            wholeString = wholeString.Replace("6", "1");
            wholeString = wholeString.Replace("5", "1");
            wholeString = wholeString.Replace("4", "1");
            wholeString = wholeString.Replace("3", "1");
            wholeString = wholeString.Replace("2", "1");
            while (serialNumb < index)
            {
                if (zeroTracking == false)
                {
                    if (wholeString.Contains("1") == true && whileCounter < 100000)
                    {
                        if (matrixIsNotZero(whileCounter, strIndex.ToString().PadLeft(2, '0') + wholeString) == true)
                        {
                            lastNumb = whileCounter;
                            wholeString = matrixDel(whileCounter, strIndex.ToString().PadLeft(2, '0') + wholeString);
                            serialNumb += 1;
                        }
                        whileCounter += 1;
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSerialNumber receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
                else
                {
                    if (wholeString.Contains("0") == true && whileCounter < 100000)
                    {
                        if (matrixIsNotZero(whileCounter, strIndex.ToString().PadLeft(2, '0') + wholeString) == false)
                        {
                            lastNumb = whileCounter;
                            wholeString = matrixAdd(lastNumb, strIndex.ToString().PadLeft(2, '0') + wholeString);
                            serialNumb += 1;
                        }
                        whileCounter += 1;
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: matrixIndexSerialNumber receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1Function stopped. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
            }
            return lastNumb;
        }
        static public int matrixIndexSerialNumberX(int index, string wholeString, string symbTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return 0;
            }

            int serialNumb = 0;
            int lastNumb = 0;
            int whileCounter = 0;
            while (serialNumb < index)
            {
                if (wholeString.Contains(symbTracking) == true)
                {
                    if (matrixIndex(whileCounter, strIndex.ToString().PadLeft(2, '0') + wholeString) == symbTracking.PadLeft(strIndex, '0'))
                    {
                        lastNumb = whileCounter;
                        wholeString = matrixDel(lastNumb, strIndex.ToString().PadLeft(2, '0') + wholeString);
                        serialNumb += 1;
                    }
                    whileCounter += 1;
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: matrixIndexSerialNumber receiver: REL");
                    Form1.InSim.Send_MST_Message("/msg ^3» ^1Function stopped. A value of 0(zero) was returned.");
                    //REL = Risk of Endless Loop
                    return 0;
                }
            }
            return lastNumb;
        }

        public static int matrixStage(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return 0;
            }

            return int.Parse(wholeString.Substring(index * strIndex - strIndex, strIndex));
        }
        #endregion
    }
}
